implementation module menucreate


//	Clean Object I/O library, version 1.1


import	StdBool, StdList, StdMisc, StdTuple
import	StdMenuElementClass, StdPSt
import	devicesystemstate, iostate, menuaccess, menudefaccess, menuhandle
from	menuevent	import MenuSystemStateGetMenuHandles, MenuHandlesGetMenuStateHandles


menucreateFatalError :: String String -> .x
menucreateFatalError rule error
	= FatalError rule "menucreate" error


/*	Creating menus:	*/

OpenMenu` :: !(Maybe Id) .ls !(Menu m .ls (PSt .l .p)) !(IOSt .l .p) -> (!ErrorReport,!IOSt .l .p)	| MenuElements m
OpenMenu` optMenuId ls mDef ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	  mHs				= MenuSystemStateGetMenuHandles mDevice
	| isJust optMenuId && Contains (isMenuWithThisId (fromJust optMenuId)) mHs.mMenus
		= (ErrorIdsInUse,IOStSetDevice (MenuSystemState mHs) ioState)
	# (tb,ioState)		= getIOToolbox ioState
	  (menus,mHs)		= MenuHandlesGetMenuStateHandles mHs
	  (nrmenus,menus)	= Ulength menus
	  (optIndex,mDef)	= menuDefGetIndex mDef
	  index				= if (isJust optIndex) (fromJust optIndex) nrmenus
	  hasMenuWindowMenu	= Contains (isMenuWithThisId WindowMenuId) menus
	  index`			= SetBetween index 0 (max 0 (if hasMenuWindowMenu (nrmenus-1) nrmenus))
	# (rt,ioState)		= IOStGetReceiverTable ioState
	# (ioid,ioState)	= IOStGetIOId ioState
	# (ok,mH,mHs,rt,tb)	= createMenu index` ioid ls mDef mHs rt tb
 	# ioState			= IOStSetReceiverTable rt ioState
	| not ok
		= (ErrorIdsInUse,IOStSetDevice (MenuSystemState mHs) ioState)
	# (before,after)	= splitAt index` menus
	  mHs				= {mHs & mMenus=before++[mH:after]}
	# ioState			= setIOToolbox (DrawMenuBar tb) ioState
	# ioState			= IOStSetDevice (MenuSystemState mHs) ioState
	| otherwise
		= (NoError,ioState)
where
	createMenu :: !Int !SystemId .ls !(Menu m .ls .ps) !(MenuHandles .ps) !ReceiverTable !*OSToolbox
						  -> (!Bool,MenuStateHandle .ps,!MenuHandles .ps, !ReceiverTable,!*OSToolbox) | MenuElements m
	createMenu index ioId ls mDef mHs=:{mOSMenuBar=menuBar, mMenuIds=menuIds, mKeys=keys} rt tb
		# (menuId,menuIds)		= validateMenuId mDef menuIds
		  items					= menuDefGetElements mDef
		  itemHs				= menuElementToHandles items
		  itemHs				= map MenuElementStateToMenuElementHandle itemHs
		  (ok,itemHs,rt)		= menuIdsAreConsistent ioId menuId itemHs rt
		| not ok
			= (False,undef,mHs,rt,tb)
		# (menu,mlsH,menuBar,tb)= NewMenuHandle mDef index menuId menuBar tb
		# (_,itemHs,keys,tb)	= createMenuElements menu 1 itemHs keys tb
		  mlsH					= {mlsH & mItems=itemHs}
		  mHs					= {mHs & mOSMenuBar=menuBar, mMenuIds=menuIds, mKeys=keys}
		| otherwise
			= (True,MenuLSHandle {mlsState=ls,mlsHandle=mlsH},mHs,rt,tb)

isMenuWithThisId :: !Id !(MenuStateHandle .ps) -> Bool
isMenuWithThisId id msH
	= id==fst (menuStateHandleGetMenuId msH)


/*	Creating menu elements: retrieving toolbox handles and ids for elements, and building the menu gui.
*/
createMenuElements :: !OSMenu !Int ![MenuElementHandle .ls .ps] ![Char] !*OSToolbox
						  -> (!Int,![MenuElementHandle .ls .ps],![Char],!*OSToolbox)
createMenuElements menu iNr itemHs keys tb
	| isEmpty itemHs
		= (iNr,itemHs,keys,tb)
	# (itemH,itemHs)		= HdTl itemHs
	# (iNr,itemH, keys,tb)	= createMenuElement  menu iNr itemH keys tb
	# (iNr,itemHs,keys,tb)	= createMenuElements menu iNr itemHs keys tb
	| otherwise
		= (iNr,[itemH:itemHs],keys,tb)
where
	createMenuElement :: !OSMenu !Int !(MenuElementHandle .ls .ps) ![Char] !*OSToolbox
							 -> (!Int, !MenuElementHandle .ls .ps, ![Char],!*OSToolbox)
	createMenuElement menu iNr (SubMenuHandle subH) keys tb
		# (subH,tb)				= NewSubMenuHandle subH iNr menu tb
		# (_,itemHs,keys,tb)	= createMenuElements subH.mSubHandle 1 subH.mSubItems keys tb
		  subH					= {subH & mSubItems=itemHs}
		= (iNr+1,SubMenuHandle subH,keys,tb)
	createMenuElement menu iNr (RadioMenuHandle itemH=:{mRadioItems=itemHs}) keys tb
		# (iNr,itemHs,keys,tb)	= createMenuElements menu iNr itemHs keys tb
		= (iNr,RadioMenuHandle {itemH & mRadioItems=itemHs},keys,tb)
	createMenuElement menu iNr (MenuItemHandle itemH) keys tb
		# (itemH,keys)			= checkshortcutkey itemH keys
		# (osMenuItem,tb)		= insertMenu menu iNr itemH tb
		  itemH					= {itemH & mOSMenuItem=osMenuItem}
		= (iNr+1,MenuItemHandle itemH,keys,tb)
	createMenuElement menu iNr (MenuSeparatorHandle itemH) keys tb
		# (osMenuSeparator,_,tb)= OSAppendMenuSeparator iNr menu tb
		  itemH					= {itemH & mOSMenuSeparator=osMenuSeparator}
		= (iNr+1,MenuSeparatorHandle itemH,keys,tb)
	createMenuElement menu iNr itemH=:(MenuReceiverHandle _) keys tb
		= (iNr,itemH,keys,tb)
	createMenuElement menu iNr (MenuListLSHandle itemHs) keys tb
		# (iNr,itemHs,keys,tb)	= createMenuElements menu iNr itemHs keys tb
		= (iNr,MenuListLSHandle itemHs,keys,tb)
	createMenuElement menu iNr (MenuExtendLSHandle exH=:{mExtendItems=itemHs}) keys tb
		# (iNr,itemHs,keys,tb)	= createMenuElements menu iNr itemHs keys tb
		= (iNr,MenuExtendLSHandle {exH & mExtendItems=itemHs},keys,tb)
	createMenuElement menu iNr (MenuChangeLSHandle chH=:{mChangeItems=itemHs}) keys tb
		# (iNr,itemHs,keys,tb)	= createMenuElements menu iNr itemHs keys tb
		= (iNr,MenuChangeLSHandle {chH & mChangeItems=itemHs},keys,tb)
	createMenuElement _ _ _ _ _
		= menucreateFatalError "createMenuElements" "unmatched MenuElementHandle"

/* PA: not used.
SubMenuHandleGetDefValues :: !(SubMenuHandle .ls .ps) -> (![MenuElementHandle .ls .ps],!Title,!Bool)
SubMenuHandleGetDefValues {mSubItems,mSubTitle,mSubSelect}
	= (mSubItems,mSubTitle,mSubSelect)
*/

/*	Extend an existing menu with new menu elements.
*/
extendMenu :: !OSMenu !Int ![MenuElementHandle .ls .ps] ![MenuElementHandle .ls .ps] ![Char] !*OSToolbox
													-> (![MenuElementHandle .ls .ps],![Char],!*OSToolbox)
extendMenu menu iNr itemHs items keys tb
	| isEmpty itemHs
	= (items,keys,tb)
	# (itemH,itemHs)	= HdTl itemHs
	# (items,keys,tb)	= extendMenu  menu iNr itemHs items keys tb
	# (itemH,keys,tb)	= extendMenu` menu iNr itemH        keys tb
	= ([itemH:items],keys,tb)
where
	extendMenu` :: !OSMenu !Int !(MenuElementHandle .ls .ps) ![Char] !*OSToolbox -> (!MenuElementHandle .ls .ps,![Char],!*OSToolbox)
/* RWS +++
	extendMenu` menu iNr (SubMenuHandle subH) keys tb
		# (ok,sId,tb)					= OSNewSubMenuNr tb
		| not ok
		= menucreateFatalError "extendMenu" "To many SubMenus created for one interactive process"
		# (subH,subMenuH,tb)			= newSubMenuHandle subH sId tb
		  (subItems,title,enabled)		= SubMenuHandleGetDefValues subMenuH
		  (submenu,subH)				= (\mH=:{mSubHandle}->(mSubHandle,mH)) subH
		# (_,subItems,sIds,keys,tb)		= createMenuElements submenu 1 subItems keys tb
		  subH							= {subH & mSubItems=subItems}
		# (subH,tb)						= InsertSubMenu subH tb
		  (mactitle,macstr)				= subMenuHandleToMacElement title sId enabled
		# tb							= InsMenuItem menu macstr iNr tb
		# tb							= SetItem menu (iNr+1) mactitle tb
		= (SubMenuHandle subH,keys,tb)
*/
	extendMenu` menu iNr (SubMenuHandle subH) keys tb
		# (subH,tb)						= NewSubMenuHandle subH iNr menu tb
		# (_,itemHs,keys,tb)			= createMenuElements subH.mSubHandle 1 subH.mSubItems keys tb
		  subH							= {subH & mSubItems=itemHs}
		= (SubMenuHandle subH,keys,tb)
	extendMenu` menu iNr (RadioMenuHandle itemH=:{mRadioItems=itemHs}) keys tb
		# (_,itemHs,keys,tb)			= createMenuElements menu iNr itemHs keys tb
		= (RadioMenuHandle {itemH & mRadioItems=itemHs},keys,tb)
	extendMenu` menu iNr (MenuItemHandle itemH) keys tb
		# (itemH,keys)					= checkshortcutkey itemH keys
		# (osMenuItem,tb)				= insertMenu menu iNr itemH tb
		= (MenuItemHandle {itemH & mOSMenuItem=osMenuItem},keys,tb)
	extendMenu` menu iNr (MenuSeparatorHandle itemH) keys tb
		# (osMenuItem,_,tb)				= OSAppendMenuSeparator iNr menu tb
		= (MenuSeparatorHandle {itemH & mOSMenuSeparator=osMenuItem},keys,tb)
	extendMenu` _ _ itemH=:(MenuReceiverHandle _) keys tb
		= (itemH,keys,tb)
	extendMenu` menu iNr (MenuListLSHandle itemHs) keys tb
		# (itemHs,keys,tb)				= extendMenu menu iNr itemHs [] keys tb
		= (MenuListLSHandle itemHs,keys,tb)
	extendMenu` menu iNr (MenuExtendLSHandle mExH=:{mExtendItems=itemHs}) keys tb
		# (itemHs,keys,tb)				= extendMenu menu iNr itemHs [] keys tb
		= (MenuExtendLSHandle {mExH & mExtendItems=itemHs},keys,tb)
	extendMenu` menu iNr (MenuChangeLSHandle mChH=:{mChangeItems=itemHs}) keys tb
		# (itemHs,keys,tb)	= extendMenu menu iNr itemHs [] keys tb
		= (MenuChangeLSHandle {mChH & mChangeItems=itemHs},keys,tb)
	extendMenu` _ _ _ _ _
		= menucreateFatalError "extendMenu" "unmatched MenuElementHandle"


insertMenu :: !OSMenu !Int !(MenuItemHandle .ls .ps) !*OSToolbox -> (!OSMenuItem,!*OSToolbox)
insertMenu menu iNr {mItemKey,mItemTitle,mItemSelect,mItemMark,mItemAtts} tb
	# (osMenuItem,_,tb)	= OSAppendMenuItem iNr menu mItemTitle mItemSelect mItemMark shortcut tb
	= (osMenuItem,tb)
where
	shortcut			= case mItemKey of
							(Just key)	-> key
							_			-> '\0'

checkshortcutkey :: !(MenuItemHandle .ls .ps) ![Char] -> (!MenuItemHandle .ls .ps,![Char])
checkshortcutkey mItemH=:{mItemKey} cs
	| isNothing mItemKey
	= ( mItemH,cs)
	| isMember c cs
	= ({mItemH & mItemKey=Nothing},cs)
	= ( mItemH,[c:cs])
where
	c	= fromJust mItemKey


//	Creation and manipulation of Menu(Element)Handles:


SystemAble			:== True
SystemUnable		:== False

//	Initialisation and Allocation:

NewMenuHandle :: !(Menu m .ls .ps) !Int !Id !OSMenuBar !*OSToolbox -> (!OSMenu,!MenuHandle .ls .ps,!OSMenuBar,!*OSToolbox)
NewMenuHandle mDef index menuId menuBar tb
	# (ok,osMenuNr,tb)	= OSNewMenuNr tb		// PA: generation of internal menu numbers added
	| not ok
		= menucreateFatalError "NewMenuHandle" "To many Menus created for one interactive process"
	# (select,mDef)		= menuDefGetSelectState	mDef
	  (title,_)			= menuDefGetTitle		mDef
	# (menu,menuBar,tb)	= OSMenuInsert index osMenuNr title menuBar tb
	  mH				= {	mHandle		= menu
						  , mMenuId		= menuId
						  ,	mOSMenuNr	= osMenuNr
						  ,	mTitle		= title
						  ,	mSelect		= enabled select
				// PA---  ,	mLS			= True
						  ,	mItems		= []
						  }
	| enabled select
		= (menu,mH,menuBar,OSEnableMenu  index menuBar tb)
		= (menu,mH,menuBar,OSDisableMenu index menuBar tb)

//	PA: New version of creating a SubMenu:
NewSubMenuHandle :: !(SubMenuHandle .ls .ps) !Int !OSMenu !*OSToolbox -> (!SubMenuHandle .ls .ps,!*OSToolbox)
NewSubMenuHandle mH=:{mSubTitle,mSubSelect} index menu tb
	# (ok,osMenuNr,tb)	= OSNewSubMenuNr tb
	| not ok
		= menucreateFatalError "NewSubMenuHandle" "To many SubMenus created for one interactive process"
	# (osH,_,tb)		= OSSubMenuInsert index osMenuNr mSubTitle menu tb
	# mH				= {mH & mSubHandle=osH,mSubOSMenuNr=osMenuNr}
	| mSubSelect
		= (mH,OSEnableMenuItem  menu osH tb)
		= (mH,OSDisableMenuItem menu osH tb)

validateMenuId :: (Menu m .ls .ps) [Int] -> (!Id, ![Int])
validateMenuId mDef menuIds
	# (maybe_id,_)	= menuDefGetMenuId mDef
	| isJust maybe_id
		= (fromJust maybe_id, menuIds)
	# (menuId, menuIds)	= HdTl menuIds
	= (sysId menuId, menuIds)

disposeMenuItemHandle :: !OSMenu !Int !(MenuItemHandle .ls .ps) !(![Char],!*OSToolbox) -> (![Char],!*OSToolbox)
disposeMenuItemHandle menu iNr {mItemKey,mOSMenuItem} (keys,tb)
	# (_,tb)	= OSMenuRemoveItem mOSMenuItem menu tb
	= (if (isJust mItemKey) [fromJust mItemKey:keys] keys,tb)


disposeSubMenuHandles :: !(MenuElementHandle .ls .ps) !*OSToolbox -> *OSToolbox
/* RWS +++
disposeSubMenuHandles (SubMenuHandle {mSubHandle,mSubMacId,mSubItems}) tb
	# tb = StateMap2 disposeSubMenuHandles mSubItems tb
	  tb = DeleteMenu  mSubMacId tb
	  tb = DisposeMenu mSubHandle tb
	= tb
*/
disposeSubMenuHandles (MenuListLSHandle		 mListItems)	tb = StateMap2 disposeSubMenuHandles mListItems   tb
disposeSubMenuHandles (MenuExtendLSHandle	{mExtendItems})	tb = StateMap2 disposeSubMenuHandles mExtendItems tb
disposeSubMenuHandles (MenuChangeLSHandle	{mChangeItems})	tb = StateMap2 disposeSubMenuHandles mChangeItems tb
disposeSubMenuHandles _										tb = tb

disposeShortcutkeys :: !(MenuElementHandle .ls .ps) ![Char] -> [Char]
disposeShortcutkeys (SubMenuHandle   {mSubItems})	keys = StateMap2 disposeShortcutkeys mSubItems    keys
disposeShortcutkeys (RadioMenuHandle {mRadioItems})	keys = StateMap2 disposeShortcutkeys mRadioItems  keys
disposeShortcutkeys (MenuItemHandle	 {mItemKey})	keys
	| isJust mItemKey
	= thd3 (Remove ((==) key) key keys)
	with
		key = fromJust mItemKey
	= keys
disposeShortcutkeys (MenuListLSHandle	 mListItems)	keys = StateMap2 disposeShortcutkeys mListItems   keys
disposeShortcutkeys (MenuExtendLSHandle {mExtendItems}) keys = StateMap2 disposeShortcutkeys mExtendItems keys
disposeShortcutkeys (MenuChangeLSHandle {mChangeItems}) keys = StateMap2 disposeShortcutkeys mChangeItems keys
disposeShortcutkeys _									keys = keys

disposeMenuRIds :: !SystemId !(MenuElementHandle .ls .ps) !ReceiverTable -> ReceiverTable
disposeMenuRIds pid (MenuReceiverHandle	{mReceiverHandle={rId}}) rt
	= snd (removeReceiverFromReceiverTable rId rt)
disposeMenuRIds pid (SubMenuHandle		{mSubItems})	rt = StateMap2 (disposeMenuRIds pid) mSubItems    rt
disposeMenuRIds pid (MenuListLSHandle	mListItems)		rt = StateMap2 (disposeMenuRIds pid) mListItems   rt
disposeMenuRIds pid (MenuExtendLSHandle	{mExtendItems})	rt = StateMap2 (disposeMenuRIds pid) mExtendItems rt
disposeMenuRIds pid (MenuChangeLSHandle	{mChangeItems})	rt = StateMap2 (disposeMenuRIds pid) mChangeItems rt
disposeMenuRIds _ _										rt = rt

disposeMenuHandles :: !Bool !(MenuHandles .ps) !*OSToolbox -> *OSToolbox
disposeMenuHandles isSubProcess menus=:{mOSMenuBar,mMenus} tb
	# (osMenuBar,tb)	= disposehandles mMenus mOSMenuBar tb
	| isSubProcess
		= tb
		= OSMenuBarRemove osMenuBar tb
where
	disposehandles :: ![MenuStateHandle .ps] !OSMenuBar !*OSToolbox -> (!OSMenuBar, !*OSToolbox)
	disposehandles [mH:mHs] menuBar tb
		# (menuBar,tb)	= OSMenuRemove (fst (menuStateHandleGetHandle mH)) menuBar tb
		= disposehandles mHs menuBar tb
	disposehandles _ menuBar tb
		= (menuBar,tb)

/* RWS +++
newSubMenuHandle :: !(SubMenuHandle .ls .ps) !Int !*OSToolbox -> (!SubMenuHandle .ls .ps,!SubMenuHandle .ls .ps,!*OSToolbox)
newSubMenuHandle old_mH=:{mSubTitle=title,mSubSelect=enabled/*PA---,mSubLS=hasLS*/,mSubAtts} macId tb
	| enabled
	= (mSubH, old_mH, EnableItem  menu 0 tb1)
	= (mSubH, old_mH, DisableItem menu 0 tb1)
where
	(menu,tb1)	= NewMenu macId (validateMenuTitle title) tb
	mSubH		= {	mSubHandle	= menu
				  ,	mSubMenuId	= id
				  ,	mSubMacId	= macId
				  ,	mSubItems	= []
				  ,	mSubTitle	= title
				  ,	mSubSelect	= enabled
				  ,	mSubLS		= hasLS
				  ,	mSubAtts	= []
				  }
	defId		= MenuId (sysId macId)
	(_,idAtt)	= Select ismenuid defId mSubAtts
	id			= getmenuid idAtt

subMenuHandleToMacElement :: !Title !Int !Bool -> (!String,!String)
subMenuHandleToMacElement mSubTitle id enabled
	| enabled
	= (validateMenuItemTitle mSubTitle, submenu_id+++"D")
	= (validateMenuItemTitle mSubTitle, submenu_id+++"D"+++disable)
where
	submenu_id	= submenu+++menu_id
	submenu		= "/"+++toString (toChar 27)			// /$1B this item is a SubMenu
	menu_id		= "!"+++toString (toChar id)			// !id = menu defining the SubMenu
	disable		= "("
*/
/*	PA: newMenuItemHandle replaces the attribute list with atleast a dummy event handling function. 
		This is now ignored, because we can take advantage of this in menuevent.
newMenuItemHandle :: !(MenuItemHandle .ls .ps) !*OSToolbox -> (!MenuItemHandle .ls .ps,!*OSToolbox)
newMenuItemHandle itemH=:{mItemAtts} tb
	= ({itemH & mItemAtts=[f]},tb)
where
	(_,f)		= Select ismenufunction defF mItemAtts
	defF		= MenuFunction id
...PA*/

/* RWS +++
//	Forming the MenuBar:

InsertPullDownPosition	:== 0
InsertSubPosition		:== -1

InsertSubMenu :: !(SubMenuHandle .ls .ps) !*OSToolbox -> (!SubMenuHandle .ls .ps, !*OSToolbox)
InsertSubMenu mH=:{mSubHandle} tb
	= (mH, InsertMenu mSubHandle InsertSubPosition tb)
*/
